/*
 * Decompiled with CFR 0.152.
 */
package com.zerog.common.io.codecs.macbinary.decoding;

import com.zerog.common.io.codecs.macbinary.common.MacBinaryFormatException;
import com.zerog.common.io.codecs.macbinary.common.MacBinaryHeader;
import com.zerog.common.io.codecs.macbinary.common.MacBinarySecondaryHeader;
import com.zerog.common.io.codecs.macbinary.common.MacFileInfo;
import com.zerog.common.io.codecs.macbinary.decoding.MBDecoder;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;

public abstract class BaseMBDecoder
implements MBDecoder {
    private String sourcePath = null;
    private File sourceFile = null;
    private InputStream sourceStream = null;
    private boolean overrideOutput = true;
    private boolean strictHeader = true;
    public MacBinaryHeader macBinaryHeader = null;
    public MacBinarySecondaryHeader macBinarySecondaryHeader = null;
    private InputStream macBinaryStream = null;
    private int currentOffset = 0;
    public long bytesSaved = 0L;

    public void setOverrideOutput(boolean bl) {
        this.overrideOutput = bl;
    }

    public void setStrictMacBinaryFormat(boolean bl) {
        this.strictHeader = bl;
    }

    public void setSource(InputStream inputStream) {
        this.reset();
        this.sourceStream = inputStream;
    }

    public void setSource(File file) {
        this.reset();
        this.sourceFile = file;
    }

    public void setSource(String string) {
        this.reset();
        this.sourcePath = string;
    }

    private void reset() {
        this.sourceFile = null;
        this.sourcePath = null;
        this.sourceStream = null;
        this.macBinaryStream = null;
        this.macBinaryHeader = null;
        this.macBinarySecondaryHeader = null;
        this.bytesSaved = 0L;
        this.currentOffset = 0;
    }

    public File decode() throws IOException {
        return this.decode(this.getOutputPath());
    }

    public File decode(String string) throws IOException {
        return this.decode(string, this.getOutputName(this.getMacBinaryHeader()));
    }

    public File decode(String string, String string2) throws IOException {
        String string3;
        File file;
        this.bytesSaved = 0L;
        MacBinaryHeader macBinaryHeader = this.getMacBinaryHeader();
        InputStream inputStream = null;
        if (string == null || string2 == null || "".equals(string2)) {
            throw new IllegalArgumentException("The macbinary source stream has not been set correctly! Could not determine the full path to the output file.");
        }
        if (macBinaryHeader == null) {
            throw new MacBinaryFormatException("Header does not have the valid formatThe file might not be a macbinary file.");
        }
        inputStream = this.getMacBinaryStream();
        if (inputStream == null) {
            throw new IllegalArgumentException("The macbinary source stream has not been set correctly!Could not get the mac binary input stream");
        }
        if (!this.overrideOutput) {
            string2 = BaseMBDecoder.computeUniqueName(string, string2);
        }
        File file2 = new File(string);
        file2.mkdirs();
        string = file2.getAbsolutePath();
        if (!string.endsWith(File.separator)) {
            string = string + File.separator;
        }
        if ((file = new File(string3 = string + string2)).exists()) {
            file.delete();
        }
        RandomAccessFile randomAccessFile = new RandomAccessFile(string3, "rw");
        randomAccessFile.close();
        int n = macBinaryHeader.getDataForkOffset() - this.currentOffset;
        int n2 = macBinaryHeader.getResourceForkOffset() - this.currentOffset;
        int n3 = (int)macBinaryHeader.getDataForkLength();
        int n4 = (int)macBinaryHeader.getResourceForkLength();
        if (n < n2) {
            inputStream.skip(n);
            if (n3 > 0) {
                this.writeDataFork(inputStream, file, n3);
            }
            n2 = n2 - n - n3;
            inputStream.skip(n2);
            if (n4 > 0) {
                this.writeResourceFork(inputStream, file, n4);
            }
        } else {
            inputStream.skip(n2);
            if (n4 > 0) {
                this.writeResourceFork(inputStream, file, n4);
            }
            n = n - n2 - n4;
            inputStream.skip(n);
            if (n3 > 0) {
                this.writeDataFork(inputStream, file, n3);
            }
        }
        this.writeMacFileInfo(macBinaryHeader, file);
        return file;
    }

    public void decode(OutputStream outputStream) throws IOException {
        throw new IllegalArgumentException("This decoder (" + this.getClass() + ") does not support this decode method! ");
    }

    public boolean isMacBinaryEncoded() {
        boolean bl = false;
        try {
            bl = this.getMacBinaryHeader() != null;
            this.getMacBinaryStream().reset();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    public long getTotalSize() {
        long l = 0L;
        if (this.isMacBinaryEncoded()) {
            if (this.macBinaryHeader != null) {
                l += this.macBinaryHeader.getResourceForkLength();
                l += this.macBinaryHeader.getDataForkLength();
            }
        } else {
            l = -1L;
        }
        return l;
    }

    public long getBytesSaved() {
        return this.bytesSaved;
    }

    private String getSourceParentPath() throws FileNotFoundException {
        String string = null;
        if (this.sourcePath != null) {
            File file = new File(this.sourcePath);
            string = new File(file.getAbsolutePath()).getParent();
            file = null;
        } else if (this.sourceFile != null) {
            File file = new File(this.sourceFile.getAbsolutePath());
            string = file.getParent();
            file = null;
        }
        return string;
    }

    private String getSourceName() {
        String string = null;
        if (this.sourcePath != null) {
            string = new File(this.sourcePath).getName();
        } else if (this.sourceFile != null) {
            string = this.sourceFile.getName();
        }
        return string;
    }

    private String getOutputPath() throws FileNotFoundException {
        return this.getSourceParentPath();
    }

    public String getLongFileName() {
        String string = null;
        try {
            MacBinarySecondaryHeader macBinarySecondaryHeader = this.getMacBinarySecondaryHeader();
            if (macBinarySecondaryHeader != null) {
                string = macBinarySecondaryHeader.getLongFileName();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    private String getOutputName(MacBinaryHeader macBinaryHeader) throws FileNotFoundException {
        String string = null;
        try {
            macBinaryHeader.loadNameAndEncoding();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        string = this.getLongFileName();
        if (string == null || "".equals(string)) {
            string = macBinaryHeader.getLeafName();
        }
        if ((string == null || "".equals(string)) && (string = this.getSourceName()).endsWith(".bin")) {
            string = string.substring(0, string.length() - 4);
        }
        return string;
    }

    private InputStream getMacBinaryStream() throws IOException {
        if (this.macBinaryStream == null) {
            if (this.sourcePath != null) {
                this.macBinaryStream = new BufferedInputStream(new FileInputStream(this.sourcePath));
            } else if (this.sourceFile != null) {
                this.macBinaryStream = new BufferedInputStream(new FileInputStream(this.sourceFile));
            } else if (this.sourceStream != null) {
                this.macBinaryStream = this.sourceStream;
                if (!this.macBinaryStream.markSupported()) {
                    this.macBinaryStream = new BufferedInputStream(this.macBinaryStream);
                }
            }
            if (this.macBinaryStream != null) {
                this.macBinaryStream.mark(128);
            }
        }
        return this.macBinaryStream;
    }

    private MacBinaryHeader getMacBinaryHeader() throws IOException {
        if (this.macBinaryHeader == null) {
            this.macBinaryHeader = this.readMacBinaryHeader(this.getMacBinaryStream());
        }
        return this.macBinaryHeader;
    }

    private MacBinarySecondaryHeader getMacBinarySecondaryHeader() throws IOException {
        MacBinaryHeader macBinaryHeader = this.getMacBinaryHeader();
        InputStream inputStream = this.getMacBinaryStream();
        if (this.macBinarySecondaryHeader == null) {
            int n = macBinaryHeader.getSecondaryOffset();
            int n2 = macBinaryHeader.getSecondaryLength();
            int n3 = macBinaryHeader.getResourceForkOffset();
            int n4 = macBinaryHeader.getDataForkOffset();
            if (n2 > 0 && n < n3 && n < n4) {
                byte[] byArray = new byte[n2];
                inputStream.skip(n);
                this.currentOffset = n;
                int n5 = inputStream.read(byArray);
                if (n5 > 0) {
                    this.currentOffset += n5;
                }
                if (n5 == n2) {
                    this.macBinarySecondaryHeader = new MacBinarySecondaryHeader(byArray);
                } else {
                    throw new IOException("Error reading Secondary header: Expected " + n2 + " bytes, " + "Read " + n5 + " bytes.");
                }
            }
        }
        return this.macBinarySecondaryHeader;
    }

    private MacBinaryHeader readMacBinaryHeader(InputStream inputStream) throws IOException {
        MacBinaryHeader macBinaryHeader;
        if (!inputStream.markSupported()) {
            throw new IllegalArgumentException("Mark must be supported by the MacBinary InputStream! " + inputStream);
        }
        inputStream.mark(128);
        byte[] byArray = new byte[128];
        int n = inputStream.read(byArray);
        inputStream.reset();
        if (n < 128) {
            int n2 = 0;
            int n3 = 0;
            inputStream.mark(128);
            while (n3 < 128 && n2 != -1) {
                n2 = inputStream.read();
                byArray[n3] = (byte)n2;
                ++n3;
            }
            if (n3 < 128) {
                throw new IllegalArgumentException("The MacBinaryStream does not contain enough data to form a valid header. Data needed: 128, Data available: " + n3);
            }
            inputStream.reset();
        }
        if ((macBinaryHeader = new MacBinaryHeader(byArray)).checkFormat(this.strictHeader) <= 0) {
            throw new IOException("The stream does not contain a valid MacBinary header " + inputStream);
        }
        return macBinaryHeader;
    }

    public void pipeStreams(InputStream inputStream, OutputStream outputStream, long l) throws IOException {
        int n = 0;
        long l2 = l;
        int n2 = (int)Math.min(l, 4096L);
        byte[] byArray = new byte[n2];
        do {
            if ((n = inputStream.read(byArray, 0, (int)Math.min(l2, (long)n2))) >= 0) {
                outputStream.write(byArray, 0, n);
                this.bytesSaved += (long)n;
                continue;
            }
            throw new IOException("Early end of stream. Expected " + l + " bytes, read " + (l - l2) + " bytes.");
        } while ((l2 -= (long)n) > 0L);
    }

    private static String computeUniqueName(String string, String string2) {
        File file;
        String string3 = "";
        String string4 = string2;
        int n = 0;
        File file2 = new File(string);
        if (!(string = file2.getAbsolutePath()).endsWith(File.separator)) {
            string = string + File.separator;
        }
        if ((file = new File(string + string2)).exists()) {
            int n2 = string2.lastIndexOf(".");
            if (n2 >= 0) {
                string4 = string2.substring(0, n2);
                string3 = string2.substring(n2, string2.length());
            } else {
                string4 = string2;
            }
            while (file.exists()) {
                file = new File(string + string4 + "." + ++n + string3);
            }
            string4 = string4 + "." + Integer.toString(n) + string3;
        }
        return string4;
    }

    private static String computeUniqueFilePath(String string, String string2) {
        File file = new File(string);
        if (!(string = file.getAbsolutePath()).endsWith(File.separator)) {
            string = string + File.separator;
        }
        string2 = BaseMBDecoder.computeUniqueName(string, string2);
        return string + string2;
    }

    public void writeDataFork(InputStream inputStream, File file, long l) throws IOException {
        inputStream.skip(l);
    }

    public void writeResourceFork(InputStream inputStream, File file, long l) throws IOException {
        inputStream.skip(l);
    }

    public void writeMacFileInfo(MacFileInfo macFileInfo, File file) throws IOException {
    }
}

