/*
 * Decompiled with CFR 0.152.
 */
package com.zerog.common.io.codecs.macbinary.common;

import com.zerog.common.io.codecs.macbinary.common.MacBinary;
import com.zerog.common.io.codecs.macbinary.common.MacBinaryFormatException;
import com.zerog.common.io.codecs.macbinary.common.MacFileInfo;
import com.zerog.common.io.codecs.macbinary.util.Byter;
import com.zerog.common.io.codecs.macbinary.util.MacTime;
import java.io.UnsupportedEncodingException;

public class MacBinaryHeader
extends Byter
implements MacFileInfo {
    public static final int LENGTH = 128;
    public static final int LIMIT_SECONDARY = 65535;
    public static final long LIMIT_DATAFORK = Integer.MAX_VALUE;
    public static final int LIMIT_COMMENT = 200;
    public static final int ZERO_1_AT = 0;
    public static final int NAME_LEN_AT = 1;
    public static final int NAME_BYTES_AT = 2;
    public static final int FILE_TYPE_AT = 65;
    public static final int FILE_CREATOR_AT = 69;
    public static final int FINDER_FLAGS1_AT = 73;
    public static final int ZERO_2_AT = 74;
    public static final int FINDER_VERT_AT = 75;
    public static final int FINDER_HORZ_AT = 77;
    public static final int FINDER_WINDOW_AT = 79;
    public static final int FLAG_LOCKED_AT = 81;
    public static final int ZERO_3_AT = 82;
    public static final int LEN_DATA_FORK_AT = 83;
    public static final int LEN_RES_FORK_AT = 87;
    public static final int WHEN_CREATED_AT = 91;
    public static final int WHEN_MODIFIED_AT = 95;
    public static final int LEN_COMMENT_AT = 99;
    public static final int FINDER_FLAGS2_AT = 101;
    public static final int MB3_SIGNATURE_AT = 102;
    public static final int NAME_SCRIPT_AT = 106;
    public static final int FINDER_FLAGS3_AT = 107;
    public static final int LEN_SECONDARY_AT = 120;
    public static final int VERSION_TARGET_AT = 122;
    public static final int VERSION_MIN_AT = 123;
    public static final int CRC_AT = 124;
    public static final int VERSION_OBSOLETE_AT = 126;
    public static final int _AT = 0;
    public static final int HEADER_LIMIT_NAME = 63;
    public static final int MB_LIMIT_NAME = 31;
    public static final int MB1_VERSION = 128;
    public static final int MB2_VERSION = 129;
    public static final int MB3_VERSION = 130;
    public static final int MB3_SIGNATURE = 1833060686;
    public static final int[] levelMasks = new int[]{0xFFFE7F, 64512, 64590, 64590};
    private byte[] myComment;
    private String myLeafName;
    private String myNameEncoding;

    public MacBinaryHeader() {
        super(128);
        this.clear();
    }

    public MacBinaryHeader(byte[] byArray) {
        this();
        if (byArray != null) {
            int n = byArray.length;
            if (n > 128) {
                n = 128;
            }
            System.arraycopy(byArray, 0, this.getByteArray(), 0, n);
        }
    }

    public void setCRC() {
        this.putShortAt((short)this.calcCRC(), 124);
    }

    public boolean isValidCRC() {
        return this.calcCRC() == this.getCRC();
    }

    public int calcCRC() {
        return MacBinary.calculateCRC(0, this.getByteArray(), 0, 124);
    }

    public int calcCRC2() {
        return MacBinary.calculateCRC(0, this.getByteArray(), 0, 126);
    }

    public int getCRC() {
        return this.getUShortAt(124);
    }

    public int checkFormat(boolean bl) {
        int n = this.getUByteAt(0);
        int n2 = this.getUByteAt(82);
        if (n != 0 || n2 != 0) {
            return -3;
        }
        if (bl && this.getUByteAt(74) != 0) {
            return -2;
        }
        long l = this.getDataForkLength();
        long l2 = this.getResourceForkLength();
        if (l < 0L || l > Integer.MAX_VALUE || l2 < 0L || l2 > 0xFFFFFFL) {
            return -1;
        }
        n = this.getUByteAt(1);
        if (n < 1 || n > 63) {
            return 0;
        }
        if (!this.isValidCRC() || this.getUByteAt(123) < 129) {
            return 1;
        }
        n = this.getIntAt(102);
        if (n != 1833060686) {
            return 2;
        }
        return 3;
    }

    public int setFormatIdentity(int n) {
        int n2;
        int n3;
        if (n <= 0 || n > 3) {
            n = 3;
        }
        this.putByteAt((byte)0, 0);
        this.putByteAt((byte)0, 74);
        this.putByteAt((byte)0, 82);
        this.putShortAt((short)0, 126);
        int n4 = 0;
        if (n == 3) {
            n3 = 108;
            n2 = 119;
            n4 = 129;
        } else if (n == 2) {
            n3 = 102;
            n2 = 119;
            n4 = 129;
        } else {
            n3 = 101;
            n2 = 127;
        }
        this.putByteAt((byte)n4, 122);
        this.putByteAt((byte)-127, 123);
        this.putIntAt(1833060686, 102);
        while (n3 <= n2) {
            this.putByteAt((byte)0, n3++);
        }
        return n;
    }

    public void finishHeader(int n) throws MacBinaryFormatException {
        if (!this.encodeNameBytes()) {
            throw new MacBinaryFormatException("Failed to encode name");
        }
        if (this.setFormatIdentity(n) > 1) {
            this.setCRC();
        }
    }

    public void clear() {
        super.clear();
        this.myComment = null;
        this.myLeafName = "";
        this.setNameEncoding(null);
        this.setFormatIdentity(0);
    }

    public void copyFrom(MacFileInfo macFileInfo) {
        this.clear();
        if (macFileInfo == null) {
            return;
        }
        if (macFileInfo instanceof MacBinaryHeader) {
            this.setNameEncoding(((MacBinaryHeader)macFileInfo).getNameEncoding());
        }
        this.setName(macFileInfo.getLeafName());
        this.setForks(macFileInfo.getDataForkLength(), macFileInfo.getResourceForkLength());
        this.setFileType(macFileInfo.getFileType());
        this.setFileCreator(macFileInfo.getFileCreator());
        this.setFinderFlags(macFileInfo.getFinderFlags());
        this.setLocked(macFileInfo.isLocked());
        this.setTimeCreated(macFileInfo.getTimeCreated());
        this.setTimeModified(macFileInfo.getTimeModified());
        this.setFinderIconAt(macFileInfo.getFinderIconXAt(), macFileInfo.getFinderIconYAt());
        this.setCommentBytes(macFileInfo.getComment().getBytes());
    }

    public String getLeafName() {
        return this.myLeafName;
    }

    public void setName(String string) {
        if (string == null) {
            string = "";
        }
        this.myLeafName = string.length() > 31 ? string.substring(0, 31) : string;
        this.encodeNameBytes();
    }

    public void loadNameAndEncoding() throws UnsupportedEncodingException {
        this.myNameEncoding = MacBinary.getEncoding(this.getUByteAt(106), "MacRoman");
        byte[] byArray = this.getByteArray();
        int n = this.getUByteAt(1);
        this.myLeafName = new String(byArray, 2, n, this.myNameEncoding);
    }

    public String getNameEncoding() {
        return this.myNameEncoding;
    }

    public void setNameEncoding(String string) {
        if (string == null || string.length() == 0) {
            string = "MacRoman";
        }
        this.myNameEncoding = string;
        this.encodeNameBytes();
    }

    public boolean encodeNameBytes() {
        this.putByteAt((byte)0, 1);
        try {
            byte[] byArray;
            int n;
            String string = this.getNameEncoding();
            String string2 = this.getLeafName();
            if (string2.length() > 31) {
                string2 = string2.substring(0, 31);
            }
            if ((n = (byArray = this.getLeafName().getBytes(string)).length) > 63) {
                n = 63;
            }
            System.arraycopy(byArray, 0, this.getByteArray(), 2, n);
            this.putByteAt((byte)n, 1);
            int n2 = MacBinary.getScriptCode(string);
            if (n2 < 0) {
                n2 = 0;
            }
            this.putByteAt((byte)n2, 106);
            return true;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.putByteAt((byte)0, 1);
            this.putByteAt((byte)0, 106);
            return false;
        }
    }

    private void eraseName() {
        byte[] byArray = this.getByteArray();
        byArray[1] = 0;
        int n = 2;
        while (n < 65) {
            byArray[n] = 0;
            ++n;
        }
    }

    public long getForkLength(boolean bl) {
        return this.getIntAt(bl ? 87 : 83);
    }

    public long getDataForkLength() {
        return this.getIntAt(83);
    }

    public long getResourceForkLength() {
        return this.getIntAt(87);
    }

    public void setForks(long l, long l2) {
        if (l > Integer.MAX_VALUE || l2 > 0xFFFFFFL) {
            throw new IllegalArgumentException("Fork too long");
        }
        if (l < 0L) {
            l = 0L;
        }
        if (l2 < 0L) {
            l2 = 0L;
        }
        this.putIntAt((int)l, 83);
        this.putIntAt((int)l2, 87);
    }

    public int getFileType() {
        return this.getIntAt(65);
    }

    public void setFileType(int n) {
        this.putIntAt(n, 65);
    }

    public int getFileCreator() {
        return this.getIntAt(69);
    }

    public void setFileCreator(int n) {
        this.putIntAt(n, 69);
    }

    public int getFinderFlags() {
        int n = this.getUByteAt(101);
        n |= this.getUByteAt(73) << 8;
        return n |= this.getUByteAt(107) << 16;
    }

    public void setFinderFlags(int n) {
        this.putByteAt((byte)n, 101);
        this.putByteAt((byte)(n >> 8), 73);
        this.putByteAt((byte)(n >> 16), 107);
    }

    public int maskFinderFlags(int n, int n2) {
        if (n2 < 0 || n2 >= levelMasks.length) {
            n2 = 0;
        }
        return n & levelMasks[n2];
    }

    public boolean isLocked() {
        return (1 & this.getUByteAt(81)) != 0;
    }

    public void setLocked(boolean bl) {
        this.putByteAt(bl ? (byte)1 : 0, 81);
    }

    public boolean isDirectory() {
        return false;
    }

    public boolean isAlias() {
        return (this.getFinderFlags() & 0x8000) != 0;
    }

    public long getTimeCreated() {
        return MacTime.macSecsToJavaMillis(this.getIntAt(91));
    }

    public void setTimeCreated(long l) {
        this.putIntAt((int)MacTime.javaMillisToMacSecs(l), 91);
    }

    public long getTimeModified() {
        return MacTime.macSecsToJavaMillis(this.getIntAt(95));
    }

    public void setTimeModified(long l) {
        this.putIntAt((int)MacTime.javaMillisToMacSecs(l), 95);
    }

    public short getFinderIconXAt() {
        return this.getShortAt(77);
    }

    public short getFinderIconYAt() {
        return this.getShortAt(75);
    }

    public void setFinderIconAt(short s, short s2) {
        this.putShortAt(s, 77);
        this.putShortAt(s2, 75);
        this.putShortAt((short)0, 79);
    }

    public int getCommentLength() {
        if (this.myComment != null) {
            return this.myComment.length;
        }
        return this.headerCommentLength();
    }

    public String getComment() {
        byte[] byArray = this.getCommentArray();
        if (this.getNameEncoding() == null) {
            return new String(byArray);
        }
        try {
            return new String(byArray, this.getNameEncoding());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return "";
        }
    }

    public void setCommentBytes(byte[] byArray) {
        this.myComment = MacFileInfo.EMPTY_COMMENTS;
        if (byArray != null && byArray.length > 0) {
            int n = byArray.length;
            if (n > 200) {
                n = 200;
            }
            this.myComment = new byte[n];
            System.arraycopy(byArray, 0, this.myComment, 0, n);
        }
        this.putShortAt((short)this.myComment.length, 99);
    }

    public int headerCommentLength() {
        int n = this.getUShortAt(99);
        return n < 200 ? n : 200;
    }

    public byte[] getCommentArray() {
        if (this.myComment != null) {
            return this.myComment;
        }
        int n = this.headerCommentLength();
        if (n == 0) {
            this.myComment = MacFileInfo.EMPTY_COMMENTS;
            return MacFileInfo.EMPTY_COMMENTS;
        }
        this.putShortAt((short)n, 99);
        this.myComment = new byte[n];
        int n2 = 0;
        while (n2 < this.myComment.length) {
            this.myComment[n2] = 63;
            ++n2;
        }
        return this.myComment;
    }

    public int getSecondaryLength() {
        return this.getUShortAt(120);
    }

    public void setSecondaryLength(int n) {
        this.putShortAt((short)n, 120);
    }

    public int getOverallLength() {
        return this.getCommentOffset() + MacBinary.alignUp(this.getCommentLength());
    }

    public int getSecondaryOffset() {
        return 128;
    }

    public int getDataForkOffset() {
        return this.getSecondaryOffset() + MacBinary.alignUp(this.getSecondaryLength());
    }

    public int getResourceForkOffset() {
        return this.getDataForkOffset() + MacBinary.alignUp((int)this.getDataForkLength());
    }

    public int getCommentOffset() {
        return this.getResourceForkOffset() + MacBinary.alignUp((int)this.getResourceForkLength());
    }
}

