/*
 * Decompiled with CFR 0.152.
 */
package com.zerog.common.io.codecs.macbinary;

import com.zerog.common.io.codecs.Decoder;

public class MBDecoderFactory {
    private static final String MACOSX_DECODER = "com.zerog.common.io.codecs.macbinary.decoding.macosx.MBDecoder";
    private static final String MACOS_CLASSIC_DECODER = "com.zerog.common.io.codecs.macbinary.decoding.macos.MBDecoder";
    private static final String DEFAULT_DECODER = "com.zerog.common.io.codecs.macbinary.decoding.java.MBDecoder";

    private MBDecoderFactory() {
    }

    public static Decoder createDecoder() throws IllegalArgumentException {
        Decoder decoder = null;
        String string = "";
        String string2 = System.getProperty("os.name").trim();
        string = "Mac OS X".equalsIgnoreCase(string2) ? MACOSX_DECODER : ("Mac OS".equalsIgnoreCase(string2) ? MACOS_CLASSIC_DECODER : DEFAULT_DECODER);
        try {
            decoder = (Decoder)Class.forName(string).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalArgumentException(classNotFoundException.getMessage());
        }
        catch (InstantiationException instantiationException) {
            throw new IllegalArgumentException(instantiationException.getMessage());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalArgumentException(illegalAccessException.getMessage());
        }
        catch (Throwable throwable) {
            throw new IllegalArgumentException(throwable.getMessage());
        }
        return decoder;
    }
}

