/*
 * Decompiled with CFR 0.152.
 */
package com.zerog.common.io.codecs.macbinary.decoding.macos;

import com.apple.mrj.macos.toolbox.FSSpec;
import com.zerog.common.io.codecs.macbinary.common.MacFileInfo;
import com.zerog.common.io.codecs.macbinary.decoding.MacFileInfoWriter;
import com.zerog.common.io.codecs.macbinary.decoding.macos.CommentsWriter;
import com.zerog.common.io.codecs.macbinary.decoding.macos.MacClassicInfo;
import java.io.IOException;

public class MacClassicFileInfoWriter
implements MacFileInfoWriter {
    private FSSpec spec = null;
    private MacClassicInfo macClassicInfo = null;
    private CommentsWriter commentsWriter = null;

    public MacClassicFileInfoWriter() {
        try {
            this.macClassicInfo = new MacClassicInfo();
            this.commentsWriter = new CommentsWriter();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void write() throws IOException {
        int n = 0;
        this.macClassicInfo.write();
        this.commentsWriter.write();
        if (n != 0) {
            throw new IOException("Error getting the Catalog Info: " + n);
        }
    }

    public void setTarget(String string) throws IOException {
        this.spec = new FSSpec(string);
        this.macClassicInfo.setTarget(this.spec);
        this.commentsWriter.setTarget(this.spec);
    }

    public void setMacFileInfo(MacFileInfo macFileInfo) {
        this.macClassicInfo.readFrom(macFileInfo);
        this.commentsWriter.setComments(macFileInfo.getCommentArray());
    }
}

