/*
 * Decompiled with CFR 0.152.
 */
package com.zerog.common.io.codecs.macbinary.decoding.macos;

import com.apple.mrj.macos.libraries.InterfaceLib;
import com.apple.mrj.macos.toolbox.FSSpec;
import com.apple.mrj.macos.toolbox.Toolbox;
import com.zerog.common.io.codecs.macbinary.util.MacStringUtil;
import java.io.IOException;
import java.io.InputStream;

public class MacOSResourceForkWriter
implements InterfaceLib {
    private FSSpec spec;
    private long bytesSaved = 0L;

    public void setTarget(String string) {
        this.spec = new FSSpec(string);
    }

    public long getBytesSaved() {
        return this.bytesSaved;
    }

    public void write(InputStream inputStream, int n) throws IOException {
        if (this.spec == null) {
            throw new IllegalArgumentException("The target file has not been set!");
        }
        int[] nArray = new int[1];
        int n2 = n;
        int n3 = Math.min(n, 4000);
        byte[] byArray = new byte[n3];
        short s = this.openFileForWriting();
        try {
            while (n2 > 0) {
                nArray[0] = inputStream.read(byArray, 0, Math.min(n2, n3));
                if (nArray[0] >= 0) {
                    n2 -= nArray[0];
                    short s2 = 0;
                    Toolbox toolbox = Toolbox.LOCK;
                    synchronized (toolbox) {
                        s2 = MacOSResourceForkWriter.FSWrite(s, nArray, byArray);
                    }
                    if (s2 != 0) {
                        throw new IOException("Error (" + s2 + ") in native method writing to file: " + this.spec.toFile());
                    }
                    this.bytesSaved += (long)nArray[0];
                    continue;
                }
                throw new IOException("Early end of stream. Expected " + n + " bytes, read " + (n - n2) + " bytes. " + this.spec.toFile());
            }
            Object var12_11 = null;
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            this.closeFile(s);
            throw throwable;
        }
        this.closeFile(s);
    }

    private short openFileForWriting() throws IOException {
        short[] sArray = new short[1];
        byte[] byArray = MacStringUtil.toPStr(this.spec.getName(), 255);
        short s = this.spec.getVRefNum();
        int n = this.spec.getParID();
        byte by = 3;
        short s2 = 0;
        Toolbox toolbox = Toolbox.LOCK;
        synchronized (toolbox) {
            s2 = MacOSResourceForkWriter.HOpenRF(s, n, byArray, by, sArray);
        }
        if (s2 != 0) {
            throw new IOException("Error (" + s2 + ") in native method opening file: " + this.spec.toFile());
        }
        return sArray[0];
    }

    private void closeFile(short s) throws IOException {
        short s2 = 0;
        Toolbox toolbox = Toolbox.LOCK;
        synchronized (toolbox) {
            s2 = MacOSResourceForkWriter.FSClose(s);
        }
        if (s2 != 0) {
            throw new IOException("Error (" + s2 + ") in native method closing file: " + this.spec.toFile() + " (refnum: " + s + ")");
        }
    }

    private static native short HOpenRF(short var0, int var1, byte[] var2, byte var3, short[] var4);

    private static native short FSClose(short var0);

    private static native short FSWrite(short var0, int[] var1, byte[] var2);
}

