/*
 * Decompiled with CFR 0.152.
 */
package com.zerog.common.io.codecs.macbinary.decoding.macosx;

import com.apple.mrj.macos.carbon.CarbonLock;
import com.zerog.common.io.codecs.macbinary.common.MacFileInfo;
import com.zerog.common.io.codecs.macbinary.decoding.MacFileInfoWriter;
import com.zerog.common.io.codecs.macbinary.decoding.macosx.FSCatalogInfo;
import java.io.IOException;

public class MacOSXFileInfoWriter
implements MacFileInfoWriter {
    private static final int FSREF_STRUCTURE_SIZE = 80;
    private byte[] fsRef = new byte[80];
    private FSCatalogInfo fsCatalogInfo = new FSCatalogInfo();
    private static final int defaultInfo = 6241;

    public void setTarget(String string) throws IOException {
        try {
            byte[] byArray = string.getBytes("UTF-8");
            CarbonLock.acquire();
            int n = FSCatalogInfo.CFURLCreateFromFileSystemRepresentation(0, byArray, byArray.length, false);
            boolean bl = FSCatalogInfo.CFURLGetFSRef(n, this.fsRef);
            FSCatalogInfo.CFRelease(n);
            if (!bl) {
                throw new IOException("Unable to get a correct FSRef for the given path: " + string);
            }
            short s = 0;
            s = FSCatalogInfo.FSGetCatalogInfo(this.fsRef, 6241, this.fsCatalogInfo.getByteArray(), null, null, null);
            if (s != 0) {
                throw new IOException("Unable to get the CatalogInfo for the file (" + string + "): " + s);
            }
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            CarbonLock.release();
            throw throwable;
        }
        CarbonLock.release();
    }

    public void setMacFileInfo(MacFileInfo macFileInfo) {
        this.fsCatalogInfo.readFrom(macFileInfo);
    }

    public void write() throws IOException {
        try {
            CarbonLock.acquire();
            short s = FSCatalogInfo.FSSetCatalogInfo(this.fsRef, 6241, this.fsCatalogInfo.getByteArray());
            if (s != 0) {
                throw new IOException("Error setting the catalog info: " + s);
            }
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            CarbonLock.release();
            throw throwable;
        }
        CarbonLock.release();
    }
}

