/*
 * Decompiled with CFR 0.152.
 */
package com.zerog.common.io.codecs.macbinary;

import com.zerog.common.io.codecs.Encoder;
import com.zerog.common.io.codecs.macbinary.common.MacBinarySecondaryHeader;
import glguerin.io.FileForker;
import glguerin.io.FileInfo;
import glguerin.io.NamingStrategy;
import glguerin.io.Pathname;
import glguerin.macbinary.MacBinaryProducer;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.CRC32;

public class MBEncoder
implements Encoder {
    private Object mySource;
    private boolean mustClose;
    private boolean prepared;
    private MacBinaryProducer myProducer;
    private Pathname pathOut = new Pathname();
    private Pathname pathSource = new Pathname();
    private String mySuffix = "";
    private FileForker myForker = null;
    private NamingStrategy myStrategy = null;
    private byte[] myBuffer = new byte[1024];
    private static final int CHUNK = 1024;
    private long encodedDataLength = -1L;
    private long crc = -1L;

    public MBEncoder() {
        this.myProducer = new MacBinaryProducer();
        this.myProducer.setHeaderFormat(3);
    }

    public void configure(int n, int n2, String string) {
        if (n < 128) {
            n = 1024;
        }
        this.myBuffer = new byte[n];
        this.myProducer.setHeaderFormat(n2);
        this.mySuffix = string;
    }

    public void prepare(FileForker fileForker, NamingStrategy namingStrategy) {
        this.myForker = fileForker;
        this.myStrategy = namingStrategy;
    }

    public void setSource(InputStream inputStream) {
        this.mySource = inputStream;
    }

    public void setSource(File file) {
        this.mySource = file;
    }

    public void setSource(String string) {
        this.mySource = string;
    }

    public void prepareSource() throws IOException {
        if (!this.prepared) {
            if (this.mySource == null || this.mySource instanceof InputStream) {
                throw new IllegalArgumentException("Source is null or invalid");
            }
            File file = new File(this.mySource.toString());
            int n = file.getName().length();
            if (n > 31) {
                MacBinarySecondaryHeader macBinarySecondaryHeader = new MacBinarySecondaryHeader();
                macBinarySecondaryHeader.setLongFileName(file.getName());
                this.myProducer.setSecondaryHeader(macBinarySecondaryHeader.getBytes());
            }
            this.pathSource.setFilePath(file);
            this.myForker.useTarget(this.pathSource);
            this.prepared = true;
        }
    }

    public OutputStream getResultStream(Object object, String string) throws IOException {
        this.mustClose = false;
        if (object instanceof OutputStream) {
            return (OutputStream)object;
        }
        String string2 = "";
        if (string == null) {
            string = this.pathSource.last();
            string2 = this.mySuffix;
        }
        if (object == null) {
            this.pathOut.set(this.pathSource);
            this.pathOut.cut();
            object = this.pathOut;
            string2 = this.mySuffix;
        }
        this.pathOut.setFilePath(new File(object.toString()));
        string = this.myStrategy.composeName(this.pathOut, string, string2, this.myForker.getNameLimit());
        if (string == null) {
            throw new IOException("Can't generate name: " + string + string2);
        }
        this.pathOut.add(string);
        FileOutputStream fileOutputStream = new FileOutputStream(this.pathOut.getPath());
        this.mustClose = true;
        return fileOutputStream;
    }

    public boolean mustClose() {
        return this.mustClose;
    }

    public File encode() throws IOException {
        return this.encode(null, null);
    }

    public void encode(OutputStream outputStream) throws IOException {
        this.mbEncode(outputStream, "");
    }

    public File encode(String string) throws IOException {
        return this.encode(string, null);
    }

    public File encode(String string, String string2) throws IOException {
        long l = this.mbEncode(string, string2);
        if (l == 0L) {
            return null;
        }
        return new File(this.pathOut.getPath());
    }

    public long encodedDataLength() throws IOException {
        if (this.crc == -1L || this.encodedDataLength == -1L) {
            this.prepareSource();
            FileInfo fileInfo = this.myForker.getFileInfo(true);
            this.myProducer.setFileInfo(fileInfo);
            if (fileInfo.getForkLength(false) != 0L) {
                this.myProducer.setDataFork(this.myForker.makeForkRandomRW(false, false));
            }
            if (fileInfo.getForkLength(true) != 0L) {
                this.myProducer.setResourceFork(this.myForker.makeForkRandomRW(true, false));
            }
            CRC32 cRC32 = new CRC32();
            InputStream inputStream = this.myProducer.getMacBinaryInputStream(true);
            int n = 0;
            long l = 0L;
            byte[] byArray = new byte[512];
            while ((n = inputStream.read(byArray)) != -1) {
                cRC32.update(byArray, 0, n);
                l += (long)n;
            }
            inputStream.close();
            this.encodedDataLength = l;
            this.crc = cRC32.getValue();
        }
        return this.encodedDataLength;
    }

    public long encodedDataCrc32() throws IOException {
        if (this.crc == -1L) {
            this.encodedDataLength();
        }
        return this.crc;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long mbEncode(Object object, String string) throws IOException {
        long l = 0L;
        OutputStream outputStream = null;
        try {
            this.prepareSource();
            FileInfo fileInfo = this.myForker.getFileInfo(true);
            this.myProducer.setFileInfo(fileInfo);
            outputStream = this.getResultStream(object, string);
            if (fileInfo.getForkLength(false) != 0L) {
                this.myProducer.setDataFork(this.myForker.makeForkRandomRW(false, false));
            }
            if (fileInfo.getForkLength(true) != 0L) {
                this.myProducer.setResourceFork(this.myForker.makeForkRandomRW(true, false));
            }
            l = this.myProducer.writeMacBinary(outputStream, this.myBuffer, true);
            Object var8_7 = null;
            if (outputStream == null) return l;
            if (!this.mustClose()) return l;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (outputStream == null) throw throwable;
            if (!this.mustClose()) throw throwable;
            outputStream.close();
            throw throwable;
        }
        outputStream.close();
        return l;
    }
}

